require 'test/unit'
require 'lib/metrics_parser'

class TestMetricsParser < Test::Unit::TestCase
  def test_acceptance_scenario_full
    parser = MetricsParser.new("xmls/GinLab-R2.xml")
    collector = MetricsCollector.new
    parser.parseMetric("WMC", collector)
    assert_equal("# Average\tStdDev\tMin\tMax\tClasses: 73\n9.24657534246575\t9.52158486737401\t1.0\t47.0", collector.result)
  end

  def test_acceptance_scenario_flat
    parser = MetricsParser.new("xmls/GinLab-R1.xml")
    collector = MetricsCollector.new
    parser.parseMetric("WMC", collector)
    assert_equal("# Average\tStdDev\tMin\tMax\tClasses: 31\n7.58064516129032\t6.82043103988982\t1.0\t27.0", collector.result)
  end
end