#!/usr/bin/env ruby
# 
#  Script para processar as métricas dos arquivos XML
# 
require 'lib/metrics_parser'

groups = ["xmls/Archimedes-R1.xml", "xmls/Archimedes-R2.xml", "xmls/Archimedes-R3.xml", 
         "xmls/Archimedes-R4.xml",
         "xmls/GVC-R1.xml", "xmls/GVC-R2.xml", "xmls/GVC-R3.xml",
         "xmls/Colmeia-R1.xml", "xmls/Colmeia-R2.xml",
         "xmls/GinLab-R1.xml", "xmls/GinLab-R2.xml", "xmls/GinLab-R3.xml",
         ["xmls/Borboleta-R1-Desktop.xml", "xmls/Borboleta-R1-Movel.xml", "xmls/Borboleta-R1-Web.xml"],
         ["xmls/Borboleta-R2-Desktop.xml", "xmls/Borboleta-R2-Movel.xml", "xmls/Borboleta-R2-Web.xml"],
         ["xmls/Borboleta-R3-Desktop.xml", "xmls/Borboleta-R3-Movel.xml", "xmls/Borboleta-R3-Web.xml"],
         "xmls/Chinchilla-R1.xml", "xmls/Chinchilla-R2.xml", "xmls/Chinchilla-R3.xml",
         "xmls/Chinchilla-R4.xml", "xmls/Chinchilla-R5.xml", "xmls/Chinchilla-R6.xml", 
         "xmls/Chinchilla-R7.xml", "xmls/Chinchilla-R8.xml",
         "xmls/SPL-R1.xml", "xmls/SPL-R2.xml", "xmls/SPL-R3.xml"]
metrics = ["MLOC","WMC","DIT","NSC","LCOM","CA","CE"]

metrics.each do |metric|
  groups.each do |fGroup|
    if fGroup.is_a? String
      fGroup = [fGroup]
    end
    collector = MetricsCollector.new
    fGroup.each do |fName|
      puts "Processando #{metric} - #{fName}..."
      parser = MetricsParser.new(fName)
      parser.parseMetric(metric, collector)
    end
    puts collector.result
    $stdout.flush
  end
end